
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1360.C - Message 1360 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1360 messages.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\MSG1360.C_V  $
//   
//      Rev 1.15   09 Nov 1998 10:48:08   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//      Rev 1.3   Jul 09 1997 10:56:52   COLEJ
//    
//   
//      Rev 1.2   Feb 12 1997 16:05:50   COLEJ
//    
//   
//      Rev 1.1   Aug 13 1996 15:04:10   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:53:22   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#include <string.h>

#include <stdio.h>
#include <share.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"

void wait(float);  
void clear_message_line(void);
   
extern char  frqtblfile[32]; 
extern short LoadFrqTbl;

extern FILE  *stream4;

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1360 message from the ZMsgBuf.
//
void Dec1360(tMSGBUF *ZMsgBuf, tMSG1360 *Msg)
{                                            
   tSHORT i;

   for(i=0; i<256; i++){ 
      GetBits(&FrqTblData[i].Week , ZMsgBuf,12+i, 0, 8);   //
      GetBits(&FrqTblData[i].Error, ZMsgBuf,12+i, 8, 8);   //
   } 
}                                      
                                     
////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1360 message in the ZMsgBuf.
//
void Bld1360(tMSGBUF *ZMsgBuf, tMSG1360 *Msg)
{
   tFLOAT FreqOffset, ErrorEstimate, RateEstimate, Error;
   tSHORT Week, i, j;
   
   // load frequency table from file
   if(LoadFrqTbl && (stream4 = _fsopen(frqtblfile, "rt", SH_DENYWR)) != NULL){
      clear_message_line();
      ShowText("LOADING FREQUENCY STANDARD TABLE DATA FROM FILE ... ", CMDR, CMDC);
      LoadFrqTbl = 0;
   
      fscanf(stream4,"FREQUENCY STANDARD TABLE DATA ");
      fscanf(stream4,"FILENAME      : %*s ");   // ignore filename
      fscanf(stream4,"SET TIME      : %*lu ");  // ignore set time
      fscanf(stream4,"SEQ NUMBER    : %d " , &Msg->SequenceNumber);
      fscanf(stream4,"FREQ OFFSET   : %f " , &FreqOffset);
      fscanf(stream4,"OFFSET VALID  : %d " , &Msg->TableFreqOffsetValid);
      fscanf(stream4,"OFFSET ERROR  : %f " , &ErrorEstimate);
      fscanf(stream4,"AGING RATE    : %f " , &RateEstimate);
      fscanf(stream4,"LAST UPD WEEK : %u " , &Msg->LastRateUpdateWeek);

      Msg->TableFreqOffset     = (tSHORT) (FreqOffset    / 0.15  );
      Msg->OffsetErrorEstimate = (tSHORT) (ErrorEstimate / 0.002 );
      Msg->AgingRateEstimate   = (tSHORT) (RateEstimate  / 0.0002);

      fscanf(stream4,"ENTRY WEEK PPM");
      for(i=0; i<256; i++){
         fscanf(stream4," %d %u %f"  , &j, &Week, &Error);

         FrqTblData[j].Week  = (tSHORT) (Week  / 4   );
         FrqTblData[j].Error = (tSHORT) (Error / 0.15);
      }
   
      fclose(stream4);
      ShowText("DONE", CMDR, CMDC+52);
   }
   else{
      LoadFrqTbl = -1;
   }

   // copy message into buffer
   memcpy(((tSHORT *) ZMsgBuf)+5, Msg, sizeof(*Msg));          

   // build the header in the buffer
   PutShort  (0x81FF                         , ZMsgBuf, 1);     // message preamble
   PutShort  (1360                           , ZMsgBuf, 2);     // message number
   PutShort  (262                            , ZMsgBuf, 3);     // message length
   PutShort  (ANREQ                          , ZMsgBuf, 4);     // message ack/nack request
                                                   
   for(i=0; i<256; i++){
      PutBits(FrqTblData[i].Week  , ZMsgBuf,12+i, 0, 8);
      PutBits(FrqTblData[i].Error , ZMsgBuf,12+i, 8, 8);
   }                                         
}                                            

////////////////////////////////////////////////////////////////////////////////
//   
//   Display a Zodiac 1360 message from the ZMsgBuf.
//
void Show1360(tMSG1360 *Msg)
{
   // tbd
}                                                 
                                      
                                   